#include "General.h"

bool Functions::EndGameThreadExists = false;

void Functions::Show_Fatal_Warning(const char* Error)
{
	MessageBox(NULL, Error,"AzazelBot Error", MB_OK|MB_ICONEXCLAMATION);
	ExitProcess(0);
}

void Functions::Debug_Log(const char* Error)
{
	Console_Output("%s\n", Error);
}

void Functions::Page(int ID, const char *Format, ...)
{
	if(ID < 1 || ID > 128)
	{
		return;
	}

	if (!Get_GameObj(ID))
	{
		return;
	}

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if(Version < 2.9)
	{
		Functions::Console("ppage %d %s", ID, buffer);
		return;
	}
	else
	{
		Functions::Console("cmsgp %d %s (%s) : %s", ID, Settings::PageColour, Settings::BotName, buffer);
	}

	if(Settings::EnablePageSound)
	{
		Console("sndp %d %s", ID, Settings::PageSoundFile);
	}
}

void Functions::Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

void Functions::Create_Thread(LPTHREAD_START_ROUTINE Function, LPVOID Params)
{
	CreateThread(NULL, NULL, Function, Params, NULL, NULL);
}

DWORD WINAPI Functions::Get_Host_Name(LPVOID params)
{
	int ID = (int)params;
	StringClass IP, HostName, Nick;
		
	IP = Get_IP_Address(ID);
	Nick = Find_Player(ID)->PlayerName;

	hostent *h = 0;
	in_addr addr;
	addr.s_addr = inet_addr(IP);
 
	if (addr.s_addr == INADDR_NONE)
	{
		HostName = IP;
	}
	else
	{
		h = gethostbyaddr((char *) &addr, 4, AF_INET);
		if(!h)
		{
			HostName = IP;
		}
		else
		{
			HostName = h->h_name;
		}
	}
	
	Player::Data[ID]->Address = HostName;
	IRC::SendC(CHAN_PUBLIC, "%s's IP address/host name is: %s\n", Nick, Player::Data[ID]->Address);

	return 0;
}

DWORD WINAPI Functions::Enforce_Auth_Protect(LPVOID params)
{
	StringClass PlayerName, Text;
	int ID = (int)params;

	Sleep(2000); // 2 seconds
	
	if (Get_GameObj(ID))
	{
		PlayerName = Find_Player(ID)->PlayerName;

		Functions::Page(ID, "%s is a protected name, Identify yourself in %d seconds or you will be kicked.", PlayerName, Settings::AuthProtectInterval);
		IRC::SendC(CHAN_PUBLIC, "[Paged] %s is a protected name, Identify yourself in %d seconds or you will be kicked.", PlayerName, Settings::AuthProtectInterval);
	}
	else
	{
		return 0;
	}
	Sleep(Settings::AuthProtectInterval * 1000);

	Moderator_t* Moderator = Settings::ModsGameNick.Get(PlayerName, 0);
	if (Moderator)
	{
		if (Moderator->Access != Player::Get(ID)->Access)
		{
			IRC::SendC(CHAN_PUBLIC, "%s didn't authenticate himself!!", PlayerName);
		}
	}
	return 0;
}

GameObject* Functions::Get_Part_Name_Fixed(const char *name1)
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	int count = 0;
	GameObject *current = 0;
	while (x)
	{
		GameObject *o = (GameObject *)x->Data();
		if (o && As_SoldierGameObj(o))
		{
			const char *name = Get_Player_Name(o);
			if (stristr(name,name1))
			{
				current = o;
				count++;
			}
			delete[] name;
		}
		x = x->Next();
	}
	if ((count == 1) && (current) && (Commands->Get_ID(current)))
	{
		return current;
	}
	else
	{
		return 0;
	}
}

int Functions::Get_Part_Names_Fixed(const char *name1)
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	int count = 0;
	while (x)
	{
		GameObject *o = (GameObject *)x->Data();
		if (o && As_SoldierGameObj(o))
		{
			const char *name = Get_Player_Name(o);
			if (stristr(name,name1))
			{
				count++;
			}
			delete[] name;
		}
		x = x->Next();
	}
	return count;
}

void Functions::Announce_Auth(Player_t* Data)
{
	StringClass Translated;
	if (Data->Access == "p")
		return;
	else if (Data->Access == "+")
		Translated = "temporary moderator";
	else if (Data->Access == "%")
		Translated = "half moderator";
	else if (Data->Access == "@")
		Translated = "full moderator";
	else if (Data->Access == "&")
		Translated = "administrator";
	else if (Data->Access == "~")
		Translated = "server founder";
	
	Functions::Host_Msg("%s is a %s.", Data->Nick, Translated);
}

void Functions::Host_Msg(StringClass Text)
{
	Functions::Console("msg [%s] %s", Settings::BotAcronym, Text);
}

void Functions::Host_Msg(const char* Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	Functions::Console("msg [%s] %s", Settings::BotAcronym, buffer);
}

void Functions::Format_Time(time_t t, const char *Format, char *buffer, int Length)
{
	tm* time = new tm;
	memset((void*)time, 0x0, sizeof(time));
	time->tm_hour = (int)t / 3600;
	time->tm_min  = ((int)t % 3600) / 60;
	time->tm_sec = (int)t % 60;
	strftime(buffer, Length, Format, time);
	delete time;
}

const char* Functions::Get_Translated_Name(GameObject* obj)
{
	return Get_Translated_Preset_Name(obj);
}

void Functions::Disarm_Player(int ID)
{
	SLNode<BaseGameObj> *x = GameObjManager::GameObjList.Head();
	while (x) 
	{
		GameObject *o = (GameObject *)x->Data();
		if (o && Is_C4(o) && Get_C4_Planter(o) && Get_Player_ID(Get_C4_Planter(o)) == ID) 
		{
			Disarm_C4(o);
 		}
		else if (o && Is_Beacon(o) && Get_Beacon_Planter(o) && Get_Player_ID(Get_Beacon_Planter(o)) == ID) 
		{
			Disarm_Beacon(o);
 		}
		x = x->Next();
	}
}

void Functions::Check_Player(int ID)
{
	DLOG;
	Player_t *p = Player::Get(ID);
 
	if (!p->PlayerId)
	{
		return;
	} 
	const char *IP = Get_IP_Address(ID);
 
/*	DynamicVectorClass<DB::Column*>* rows;
	DB::Query(rows, "SELECT * FROM `Players` WHERE `Nick` = '%q' AND `ipaddress` = '%q' LIMIT 10;",p->Nick, IP);
 
	if(rows->Length() == 0)
	{
		DB::Query("INSERT INTO `Players` ( `Nick`, `ipaddress`, `Serial`) VALUES ( '%q', '%q', '%q');",p->Nick, IP, p->Serial);	
	} */
}

bool Functions::Host_Hook(int ID, TextMessageEnum Type, const char *Msg) 
{
	IRC::SendC(CHAN_PUBLIC, "%sHost%s: %s\n", BOLD, NM, Msg);
	return true;
}

bool Functions::Is_Number(const char *String)
{
	for(; *String != 0; String++)
	{
		if(!isdigit(*String))
		{
			return 0;
		}
	}
	return 1;
}

void Functions::Send_End_Map_Info(int WinType)
{
	int NodScore = (int)Get_Team_Score(0);
	int GDIScore = (int)Get_Team_Score(1);

	const char* Map = Get_Map(Get_Current_Map_Index());
	char TeamOrder[256];
	char WinString[128];

	if(NodScore > GDIScore)
	{
		sprintf(TeamOrder, "%s[Map]%s %s was won by %sNod%s with a score of%s %d %spoints to%s %d %spoints", LGREY, NM, Map, RED, NM, RED, NodScore, NM, YELLOW, GDIScore, NM);
	}
	else if(GDIScore > NodScore)
	{
		sprintf(TeamOrder, "%s[Map]%s %s was won by %sGDI%s with a score of%s %d %spoints to%s %d %spoints", LGREY, NM, Map, YELLOW, NM, YELLOW, GDIScore, NM, RED, NodScore, NM);
	}
	else
	{
		sprintf(TeamOrder, "%s[Map]%s %s was drawn with a score of%s %d %spoints to%s %d %spoints", LGREY, NM, Map, YELLOW, GDIScore, NM, RED, NodScore, NM);
	}

	if (WinType == 2)
	{
		sprintf(WinString, "by high score when time limit expired");
	}
	else if (WinType == 3)
	{
		sprintf(WinString, "by base destruction");
	}
	else if (WinType == 4)
	{
		sprintf(WinString, "by pedestal beacon placment");
	}
	else
	{
		sprintf(WinString, "by server shutdown");
	}

	IRC::SendC(CHAN_PUBLIC, "%s %s", TeamOrder, WinString);
}

const char *Functions::Get_Translated_Name(const char *Preset)
{
	const char *ret = Get_Translated_Definition_Name(Preset);
	return ret;
}

int Functions::Purchase_Hook(BaseControllerClass *base,GameObject *purchaser,unsigned int cost,unsigned int preset,const char *data)
{
	Player_t* p = Player::Get(Get_Player_ID(purchaser));

	if(data[0] == '0')
	{
		if(p->BlockBeacons == 1)
		{
			Functions::Page(p->PlayerId, "You have been blocked from buying beacons.");
			return 1;
		} 
	}	
	return -1;
	
}	
void Functions::Purchase_Mon_Hook(BaseControllerClass *base,GameObject *purchaser,unsigned int cost,unsigned int preset, unsigned int purchaseret, const char *data)
{
	if(purchaseret == 0)
	{
		if (cost > 0)
		{
			const char *Purchase = Functions::Get_Translated_Name(Get_Definition_Name(preset));
			const char *Nick = Get_Player_Name(purchaser);

			if (Purchase)
			{
				IRC::SendC(CHAN_PUBLIC, "%s[Purchase]%s %s%s purchased a %s", PURPLE, NM, Get_Team(Get_Player_ID(purchaser)) ? YELLOW : RED, Nick, Purchase);				
			}
			delete []Purchase;
			delete []Nick;
		}
	}
}

DWORD WINAPI Functions::Auto_Announce(LPVOID params)
{
	int RandomInt;
	int SizeList = Settings::AutoAnnounceList.Count();

	for(;;)
	{
		Sleep(1000 * Settings::AutoAnnounceInterval);
		RandomInt = Commands->Get_Random_Int(0, SizeList);

		Functions::Host_Msg(Settings::AutoAnnounceList[RandomInt]);
	}
}

int Functions::Get_Best_KD()
{
	float HighestKD = 0.0f;
	float ScoreHighestKD = 0.0f;
	float CurrentKD = 0.0f;
	float Deaths = 0.0f;
	int HighestKDPlayerID = 1;

	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();
		Deaths = (float)p->Deaths;
		if (Deaths == 0.0f)
		{
			Deaths += 1.0f;
		}
		CurrentKD = (float)p->Kills / (float)Deaths;
		if (CurrentKD > HighestKD)
		{
			HighestKDPlayerID = p->PlayerId;
			HighestKD = CurrentKD;
			ScoreHighestKD = (float)p->Score;
		}
		else if (CurrentKD == HighestKD)
		{
			if ((float)p->Score > ScoreHighestKD)
			{
				HighestKDPlayerID = p->PlayerId;
				HighestKD = CurrentKD;
				ScoreHighestKD = (float)p->Score;
			}
		}
	}
	return HighestKDPlayerID;
}

int Functions::Get_Most_Kills()
{
	int HighestKills = 0;
	float ScoreHighestKills = 0.0f;
	int HighestKillsPlayerID = 1;

	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();
		if (p->Kills > HighestKills)
		{
			HighestKillsPlayerID = p->PlayerId;
			HighestKills = (int)p->Kills;
			ScoreHighestKills = (float)p->Score;
		}
		else if (p->Kills == HighestKills)
		{
			if ((float)p->Score > ScoreHighestKills)
			{
			HighestKillsPlayerID = p->PlayerId;
			HighestKills = (int) p->Kills;
			ScoreHighestKills = (float)p->Score;
			}
		}
	}
	if ((HighestKills == 0) && (ScoreHighestKills == 0.0f))
	{
		return -1;
	}

	return HighestKillsPlayerID;
}

int Functions::Get_Highest_Score()
{
	float HighestScore = 0;
	int HighestScorePlayerID = 1;

	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();
		if ((float)p->Score > HighestScore)
		{
			HighestScorePlayerID = p->PlayerId;
			HighestScore = (float)p->Score;
		}
	}
	return HighestScorePlayerID;
}

DWORD WINAPI Functions::Show_End_Game_Recs(LPVOID params)
{
	EndGameRecs_t* Data = (EndGameRecs_t*)params;
	
	Sleep(40 * 1000); // 40 secs

	Functions::Host_Msg("%s has been recommended by %s for: Highest score on %s with %.0f points",
		Data->MVPName, Settings::BotName, Data->MapName, Data->MVPScore);
	Functions::Host_Msg("%s has been recommended by %s for: Most kills on %s with %.0f frags",
		Data->MostKillsName, Settings::BotName, Data->MapName, Data->MostKillsAmount);
	Functions::Host_Msg("%s has been recommended by %s for: Best K/D ratio on %s with %.0f",
		Data->BestKDName, Settings::BotName, Data->MapName, Data->MapName, Data->BestKDAmount);

	Functions::EndGameThreadExists = false;
	return 0;
}

int Functions::Get_Status(const char* Nick) // DEBUG CRAP THIS FUNCTION NEEDS TO BE PROPERLY IMPLEMENTED
{
	return 5;
}